<?php
/**
 * Plugin Name:           AutomatorWP - FluentCommunity
 * Plugin URI:            https://automatorwp.com/add-ons/fluentcomunity/
 * Description:           Connect AutomatorWP with FluentCommunity.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-fluentcommunity
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\FluentCommunity
 * @author                AutomatorWP 
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_FluentCommunity {

    /**
     * @var         AutomatorWP_FluentCommunity $instance The one true AutomatorWP_FluentCommunity
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_FluentCommunity self::$instance The one true AutomatorWP_FluentCommunity
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_FluentCommunity();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_FLUENTCOMMUNITY_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_FLUENTCOMMUNITY_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_FLUENTCOMMUNITY_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_FLUENTCOMMUNITY_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {
        	         
            // Includes
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/functions.php';

            // Triggers
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/post-added.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/post-deleted.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/comment-added.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/comment-deleted.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/join-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/leave-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/request-join-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/react-post.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/create-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/delete-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/create-course.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/delete-course.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/unroll-course.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/triggers/complete-course.php';

            // Actions
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/actions/add-user-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/actions/remove-user-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/actions/enroll-user-course.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/actions/unroll-user-course.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/actions/set-role-space.php';
            require_once AUTOMATORWP_FLUENTCOMMUNITY_DIR . 'includes/actions/add-post-space.php';
    	}
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {
        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        add_filter( 'automatorwp_licenses_meta_boxes', array( $this, 'license' ) );
        add_action( 'admin_notices', array( $this, 'admin_notices' ) );
        add_action( 'init', array( $this, 'load_textdomain' ) );
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'fluentcommunity', array(
            'label' => 'FluentCommunity',
            'icon'  => AUTOMATORWP_FLUENTCOMMUNITY_URL . 'assets/fluentcommunity.svg',
        ) );
    }

    /**
     * Licensing
     *
     * @since 1.0.0
     *
     * @param array $meta_boxes
     *
     * @return array
     */
    function license( $meta_boxes ) {

        $meta_boxes['automatorwp-fluentcommunity-license'] = array(
            'title' => 'Fluent Community',
            'fields' => array(
                'automatorwp_fluentcommunity_license' => array(
                    'type' => 'edd_license',
                    'file' => AUTOMATORWP_FLUENTCOMMUNITY_FILE,
                    'item_name' => 'Fluent Community',
                ),
            )
        );

        return $meta_boxes;

    }

	/**
     * Plugin admin notices.
     *
     * @since  1.0.0
     */
    public function admin_notices() {

        if ( ! $this->meets_requirements() && ! defined( 'AUTOMATORWP_ADMIN_NOTICES' ) ) : ?>

            <div id="message" class="notice notice-error is-dismissible">
                <p>
                    <?php printf(
                        __( 'AutomatorWP - FluentCommunity requires %s and %s in order to work. Please install and activate them.', 'automatorwp-pro' ),
                        '<a href="https://wordpress.org/plugins/automatorwp/" target="_blank">AutomatorWP</a>',
                        '<a href="https://wordpress.org/plugins/fluentcommunity/" target="_blank">FluentCommunity</a>'
                    ); ?>
                </p>
            </div>
    
            <?php define( 'AUTOMATORWP_ADMIN_NOTICES', true ); ?>
    
        <?php endif;
    
    }
    
    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {

            return false;
        }
    
        if ( ! defined( 'FLUENT_COMMUNITY_PLUGIN_DIR' ) ) {

            return false;
        }
    
        return true;
    }
    
    /**
     * Internationalization
     *
     * @access      public
     * @since       1.0.0
     * @return      void
     */
    public function load_textdomain() {

        // Set filter for language directory
        $lang_dir = AUTOMATORWP_FLUENTCOMMUNITY_DIR . '/languages/';
        $lang_dir = apply_filters( 'automatorwp_fluentcommunity_languages_directory', $lang_dir );

        // Traditional WordPress plugin locale filter
        $locale = apply_filters( 'plugin_locale', get_locale(), 'automatorwp-pro' );
        $mofile = sprintf( '%1$s-%2$s.mo', 'automatorwp-pro', $locale );

        // Setup paths to current locale file
        $mofile_local   = $lang_dir . $mofile;
        $mofile_global  = WP_LANG_DIR . '/automatorwp-fluentcommunity/' . $mofile;

        if( file_exists( $mofile_global ) ) {
            // Look in global /wp-content/languages/automatorwp-fluentcommunity/ folder
            load_textdomain( 'automatorwp-pro', $mofile_global );
        } elseif( file_exists( $mofile_local ) ) {
            // Look in local /wp-content/plugins/automatorwp-fluentcommunity/languages/ folder
            load_textdomain( 'automatorwp-pro', $mofile_local );
        } else {
            // Load the default language files
            load_plugin_textdomain( 'automatorwp-pro', false, $lang_dir );
        }     
        
    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_FluentCommunity instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_FluentCommunity The one true AutomatorWP_FluentCommunity
 */
function AutomatorWP_FluentCommunity() {
    return AutomatorWP_FluentCommunity::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_FluentCommunity' );
